<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('likes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('post_id')->constrained()->onDelete('cascade');
            $table->string('ip_address'); // or user_id if you have registered users
            $table->timestamps();
            
            $table->unique(['post_id', 'ip_address']); // prevent multiple likes per post per user
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('likes');
    }
};
