<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>{{ $post->title }}</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
  <style>
           .container ul li a {
   text-decoration: none; 
   background: linear-gradient(to right, #ffecd2, #fcb69f); 
   -webkit-background-clip: text;
    -webkit-text-fill-color: transparent; 
    font-weight: 800; 
  transition: color 0.3s ease;
}
.container ul li::after{
    content: '';
    width: 0%;
    height: 2px;
    background: goldenrod;
    display: block;
        margin: auto;
        transition: 0.5s;
}
.container ul li:hover::after{
    width: 100%;
}
.navbar-brand{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  background-clip: text;
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}
.dropdown-menu{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
}
.display-5{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  background-clip: text;
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}
.btn-primary{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  border: none;
}
.mb-4.text-center{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  background-clip: text;
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}
.btn-secondary{
  background: linear-gradient(270deg, #df8908 10%, #b415ff 100%);
  border: none;
}
    </style>

<div class="container py-5">

  <a href="{{ route('posts.index') }}" class="btn btn-secondary mb-4">← Back to Posts</a>

  <div class="card shadow-sm">
    <div class="card-body">
      <h1 class="mb-3">{{ $post->title }}</h1>
      <p class="text-muted">By {{ $post->user->name ?? 'Guest' }}</p>

      {{-- Display image if exists --}}
      @if($post->image)
        <img src="{{ asset('storage/' . $post->image) }}" class="img-fluid rounded mb-3" alt="Post image">
      @endif

      {{-- Display video if exists --}}
      @if($post->video)
        <video controls width="100%" class="rounded mb-3">
          <source src="{{ asset('storage/' . $post->video) }}" type="video/mp4">
          Your browser does not support the video tag.
        </video>
      @endif

      <hr>
      <p style="white-space: pre-wrap;">{{ $post->body }}</p>

      {{-- Edit/Delete Buttons (Admins only) --}}
      @auth('admin')
        <div class="mt-4 d-flex gap-2">
          <a href="{{ route('admin.posts.edit', $post) }}" class="btn btn-primary">✏️ Edit</a>

          <form action="{{ route('admin.posts.destroy', $post) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this post?');">
            @csrf
            @method('DELETE')
            <button type="submit" class="btn btn-danger">🗑️ Delete</button>
          </form>
        </div>
      @endauth

      {{-- Likes --}}
      <div class="mt-4">
        <form action="{{ route('posts.like', $post) }}" method="POST">
          @csrf
          <button type="submit" class="btn btn-success">
            👍 Like ({{ $post->likes->count() }})
          </button>
        </form>
      </div>

      <p class="text-muted">
  👁️ {{ $post->views }} views
</p>


      {{-- Comments --}}
      <div class="mt-4">
        <h5>Comments ({{ $post->comments->count() }})</h5>
        @foreach($post->comments as $comment)
          <div class="mb-2 border-bottom pb-2">
            <strong>{{ $comment->name }}</strong> says:
            <p>{{ $comment->body }}</p>
          </div>
        @endforeach

        {{-- Add Comment Form --}}
        <form action="{{ route('posts.comment', $post) }}" method="POST" class="mt-3">
          @csrf
          <input type="text" name="name" placeholder="Your Name" class="form-control mb-2" required>
          <input type="email" name="email" placeholder="Your Email (optional)" class="form-control mb-2">
          <textarea name="body" placeholder="Your Comment" class="form-control mb-2" rows="3" required></textarea>
          <button type="submit" class="btn btn-primary">Submit Comment</button>
        </form>
      </div>

    </div>
  </div>
</div>

</body>
</html>
