<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">

    <!-- Homepage -->
    <url>
        <loc>{{ url('/') }}</loc>
        <priority>1.0</priority>
        <changefreq>daily</changefreq>
    </url>

    <!-- Static Pages -->
    <url>
        <loc>{{ url('/privacy-policy') }}</loc>
        <priority>0.5</priority>
        <changefreq>yearly</changefreq>
    </url>

    <url>
        <loc>{{ url('/about') }}</loc>
        <priority>0.5</priority>
        <changefreq>yearly</changefreq>
    </url>

    <!-- Categories -->
<url>
    <loc>{{ url('/category/news') }}</loc>
    <priority>0.6</priority>
    <changefreq>weekly</changefreq>
</url>

<url>
    <loc>{{ url('/category/story') }}</loc>
    <priority>0.6</priority>
    <changefreq>weekly</changefreq>
</url>

<url>
    <loc>{{ url('/category/lifestyle') }}</loc>
    <priority>0.6</priority>
    <changefreq>weekly</changefreq>
</url>


    <!-- Blog Posts -->
    @foreach ($posts as $post)
        <url>
            <loc>{{ route('posts.show', $post->slug) }}</loc>
            <lastmod>{{ $post->updated_at->toAtomString() }}</lastmod>
            <priority>0.8</priority>
            <changefreq>weekly</changefreq>
        </url>
@endforeach
<!-- Archives -->
@foreach ($posts->groupBy(fn($p) => $p->created_at->format('Y')) as $year => $yearPosts)
    <url>
        <loc>{{ url('/archive/' . $year) }}</loc>
        <priority>0.5</priority>
        <changefreq>yearly</changefreq>
    </url>


    @endforeach

</urlset>
